--> pralable
-- USE BD_Air_France;

CREATE TABLE T_pilote_pil
 (pil_brevet VARCHAR(6),pil_prenom VARCHAR(15),
  pil_nom VARCHAR(15), pil_hvol DECIMAL(7,2),cmp_compa CHAR(4),
  CONSTRAINT PK_pil PRIMARY KEY(pil_brevet));

INSERT INTO T_pilote_pil VALUES ('PL-1', 'Pierre','Filloux', 450, 'AF');
INSERT INTO T_pilote_pil VALUES ('PL-2', 'Christian','Sigaudes', 0, 'AF');
INSERT INTO T_pilote_pil VALUES ('PL-3', 'Pierre','Perez', 1000, 'SING');
INSERT INTO T_pilote_pil VALUES ('PL-4', 'Romaric','Benech', 2450, 'CAST');
INSERT INTO T_pilote_pil VALUES ('PL-5', 'Vincent','Gindre', NULL, 'AF');

SELECT * FROM BD_Air_France.dbo.T_pilote_pil;

SELECT * FROM T_pilote_pil;

-- liste col

SELECT cmp_compa,pil_prenom,pil_nom,pil_brevet FROM T_pilote_pil;

-- alias

SELECT cmp_compa AS c1, pil_nom AS Nom, pil_brevet c3 
FROM   T_pilote_pil;

SELECT alias_pilotes.cmp_compa AS c1, alias_pilotes.pil_nom 
FROM   T_pilote_pil alias_pilotes;

-- alias

SELECT cmp_compa 
FROM   T_pilote_pil;

SELECT ALL cmp_compa 
FROM   T_pilote_pil;

SELECT DISTINCT cmp_compa 
FROM   T_pilote_pil;

INSERT INTO T_pilote_pil VALUES ('PL-6', 'Pierre','Filloux', 5070, 'SING');

SELECT DISTINCT pil_prenom, pil_nom
FROM   T_pilote_pil;

SELECT DISTINCT pil_prenom, pil_nom,cmp_compa
FROM   T_pilote_pil;

-- expressions et valeurs nulles

SELECT pil_brevet, 
       pil_hvol*pil_hvol AS au_carre, 
       10*pil_hvol+5.0/2 AS "10*pil_hvol+5/2"
FROM   T_pilote_pil;

-- ORDER 

SELECT   pil_brevet, pil_nom, pil_hVol 
FROM     T_pilote_pil 
ORDER BY pil_hVol DESC;

SELECT   pil_brevet, pil_prenom, pil_nom,cmp_compa
FROM     T_pilote_pil 
ORDER BY pil_nom, cmp_compa DESC;

SELECT   pil_brevet, pil_prenom, pil_nom,cmp_compa
FROM     T_pilote_pil 
ORDER BY 3, 4 DESC;

-- concat

SELECT pil_brevet, 
       CONCAT(pil_prenom,
        CONCAT('-',CONCAT(pil_nom,' vole pour ',cmp_compa))) AS "Embauche" 
FROM   T_pilote_pil;

-- insertions multilignes

CREATE TABLE T_temp_tmp
(tmp_prenom VARCHAR(15), 
 tmp_nom    VARCHAR(15), 
 tmp_hv     DECIMAL(7,2), 
 tmp_compa  CHAR(4));

INSERT INTO T_temp_tmp 
SELECT pil_prenom,pil_nom,pil_hvol,cmp_compa 
FROM   T_pilote_pil;

SELECT * FROM T_temp_tmp;
DROP TABLE T_temp_tmp;

SELECT pil_prenom,pil_nom,pil_hvol,cmp_compa AS tmp_compa
INTO   T_temp2_tmp
FROM   T_pilote_pil;

SELECT * FROM T_temp2_tmp;
DROP TABLE T_temp2_tmp;

-- cration de table

SELECT cmp_compa  AS compagnie, pil_nom AS nom, pil_prenom AS prenom,
       pil_brevet AS brevet, pil_hvol AS heures_vol
INTO   T_temp_tmp
FROM   T_pilote_pil;

DROP TABLE T_temp_tmp;

-- limiter

SELECT TOP (4)
        pil_prenom,pil_nom,pil_hvol,cmp_compa 
FROM   T_pilote_pil
ORDER BY pil_brevet;  

SELECT   TOP (40) PERCENT
         pil_prenom,pil_nom,pil_hvol,cmp_compa 
FROM     T_pilote_pil
ORDER BY pil_hvol DESC;

/* La moiti des pilotes (de manire alatoire) */

SELECT TOP((SELECT COUNT(*) FROM T_pilote_pil)/2)
       pil_prenom,pil_nom,pil_hvol,cmp_compa
FROM   T_pilote_pil;

/* offset */

SELECT pil_brevet, pil_prenom, pil_nom
FROM   T_pilote_pil
ORDER BY pil_brevet OFFSET 3 ROWS;

SELECT   pil_prenom, pil_nom, pil_hvol
FROM     T_pilote_pil
ORDER BY pil_hvol DESC OFFSET 2 ROWS FETCH NEXT 1 ROW ONLY;	


DROP TABLE T_pilote_pil;
GO